--[[
	Bongos Minimap
		skin functions
--]]


local L = LibStub('AceLocale-3.0'):GetLocale('Bongos3-Minimap')
local MaskDirectory = "Interface\\Addons\\Bongos_Minimap\\Skins\\Masks\\"
local RoundBorder = "Interface\\Addons\\Bongos_Minimap\\Skins\\Borders\\%s\\Round"
local SquareBorder = "Interface\\Addons\\Bongos_Minimap\\Skins\\Borders\\%s\\Square"

local DefaultSkins = {
	Alliance = 18,
	Blizzard = 14,
	Flat = 13,
	Thin = 2,
	Tooltip = 2,
	Tubular = 13,
}

function BongosMinimap:CreateBorderTexture(point, ...)
	local f = MinimapBackdrop:CreateTexture(nil, "ARTWORK")
	
	f:SetWidth(Minimap:GetWidth() / 2 + 10)
	f:SetHeight(Minimap:GetHeight() / 2 + 10)
	
	f:SetPoint(point, Minimap, "CENTER")
	f:SetTexCoord(...)
	
	self.borders = self.borders or {}
	tinsert(self.borders, f)
end


--[[ Set ]]--

function BongosMinimap:SetBorderSkin(border)
	if not self.skins[border] then
		self:Print(format(L.BorderSkinError, border))
		return self:SetBorderSkin("Blizzard")
	end
	
	self.sets.border = border
	border = self.skins[border]
	
	self:SetHeight(Minimap:GetHeight() + border.off)
	self:SetWidth(Minimap:GetWidth() + border.off)
	
	for i, target in pairs(self.borders) do
		target:SetTexture(self:GetBorderPath(border, self.sets.mask, i))
	end
end

function BongosMinimap:SetBorderColor(r, g, b, a)
	for i, target in pairs(self.borders) do
		target:SetVertexColor(r, g, b)
		target:SetAlpha(a)
	end
	
	self.sets.borderColor = {r = r, g = g, b = b, a = a}
end

function BongosMinimap:GetBorderPath(border, mask, i)	
	if self.Shapes[mask][i] then
		return border.round
	else
		return border.square
	end
end

function BongosMinimap:SetMask(mask)
	Minimap:SetMaskTexture(MaskDirectory .. mask)
	self.sets.mask = mask
end


--[[ Register ]]--

function BongosMinimap:RegisterDefaultSkins()
	for name, off in pairs(DefaultSkins) do
		self:RegisterSkin(name, RoundBorder:format(name), SquareBorder:format(name), off)
	end
end

function BongosMinimap:RegisterSkin(name, round, square, off)
	self.skins = self.skins or {}
	self.skins[name] = {round = round, square = square, off = off or 0}
end